/*	rename.c	1.8	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"
#include "cpmfio.h"

/*
 * Rename a cp/m file
 * returns: 1 = failure, 0 = success 
 */

/************************************************************************
 * NAME:	cpm_rename()
 *
 * DESCR:	Renames the given CPM file.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if things went OK, false otherwise.
 *
 * NOTES:	
 ************************************************************************/
int
cpm_rename(struct cpmfs *cpmfs, char *oldname, char *newname)
{
	C_FILE *cio;
	char oldnamebody[9], oldext[4], newnamebody[9], newext[4];

	if (!(cpm_namesep(oldname, oldnamebody, oldext))) 
	    return (FALSE);
	if (!(cpm_namesep(newname, newnamebody, newext))) 
	    return (FALSE);

	if (cpm_searchdir(cpmfs, oldnamebody, oldext) < 0 -1) {
	    return(FALSE);	/* file doesn't exist	*/
	}

	cio = cpm_file_open(cpmfs, oldname, oldext, READ);
	do {
	    strncpy(cio->c_dirp->name, newname, 8);
	    strncpy(cio->c_dirp->ext, newext, 3);
	} while (cpm_getnext(cio) != -1);

	cpm_savedir(cpmfs);
	cpm_file_close(cio);
	return (TRUE);
}
